import { StyleSheet, Dimensions } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
const { width } = Dimensions.get("window");

let flexWidth = width / 2 - 30;

const ProductsStyle = (prop) =>
    StyleSheet.create({
        container: {},
        pb: {
            paddingBottom: dpr(30),
        },
        columnWrapper: {
            justifyContent: 'space-between',
        },
        item: {
            marginBottom: dpr(20),
        },
        imageContainer: {
            width: flexWidth,
            height: flexWidth,
            backgroundColor: "#FFFFFF",
            marginBottom: dpr(10),
            flexDirection: "row",
            justifyContent: "center",
            alignItems: "center",
            borderRadius: 6,
            borderWidth: 1,
            borderColor: "#DFDFDF",
        },
        imgCont: {
            marginRight: dpr(20),
            borderRadius: 4,
        },
        img: {
            width: dpr(80),
            height: dpr(80),
        },
        text: {
            fontFamily: "DMSans_400Regular",
            fontSize: dpr(14),
            lineHeight: dpr(19),
            color: "#2c2c2c",
            marginVertical: dpr(7),
            width: flexWidth,
            textAlign: "left",
            // alignItems: 'flex-end',
        },
        priceCont: {
            flexDirection: prop > flexWidth ? "column" : "row",
            width: flexWidth,
            overflow: "hidden",
        },
        price: {
            fontFamily: "DMSans_700Bold",
            fontSize: dpr(14),
            lineHeight: dpr(17),
            color: "#2c2c2c",
            textAlign: 'left'
        },
        discount: {
            marginLeft: dpr(2),
            textDecorationLine: "line-through",
            color: "#CBCBCB",
            marginTop: "auto",
            fontSize: dpr(12),
            fontFamily: "DMSans_500Medium",
        },
        loadMore: {
            position: "absolute",
            bottom: dpr(10),
            left: 0,
            right: 0,
            justifyContent: "center",
            alignItems: "center",
        },
        start_mr: { marginRight: 3 },
    });

export { ProductsStyle };
